// $Id: CAnimationFrame.cpp,v 1.5 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CAnimationFrame.hpp"
using Exponent::GUI::Controls::CAnimationFrame;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CAnimationFrame, CControl);

//	===========================================================================
CAnimationFrame::CAnimationFrame(IControlRoot *root, const long uniqueId, const CRect &area) 
		       : CControl(root, uniqueId, area)
			   , m_frameHeight(0)
			   , m_frameNumber(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CAnimationFrame);
	this->setFrameNumber(0);
	this->controlIsMouseEnabled(false);
}

//	===========================================================================
CAnimationFrame::~CAnimationFrame()
{
	EXPONENT_CLASS_DESTRUCTION(CAnimationFrame);
}

//	===========================================================================
void CAnimationFrame::setAnimationImage(IImage *theImage, const long heightOfEachFrame)
{
	this->setPrimaryImage(theImage);

	// Now we can check it out :)
	if (m_primaryImage)
	{
		m_frameHeight = heightOfEachFrame;
		m_offsetArea.setOrigin(CPoint(0, 0));
		m_offsetArea.setWidth(m_primaryImage->getImageSize().getWidth());
		m_offsetArea.setHeight(m_frameHeight);
	}
}

//	===========================================================================
void CAnimationFrame::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	if (m_primaryImage)
	{
		// Set the top of the area
		m_offsetArea.setTop((m_frameHeight * m_frameNumber));
		graphics.drawImage(m_primaryImage, m_normalisedArea, m_offsetArea);
	}
}

//	===========================================================================
void CAnimationFrame::setFrameNumber(const long frameNumber)
{
	m_frameNumber = frameNumber;
	this->update();
}

//	===========================================================================
void CAnimationFrame::handleLeftButtonDown(CMouseEvent &event)
{
	if (m_actionListener)
	{
		m_actionListener->handleActionEvent(CActionEvent(this, event));
	}
}